/*

 Advanced Logger for the Sphere Community Game
 
 19 apr 2007 - inital version, Vincent van Beveren
 
 */


function Logger(filename, level) {
	this.logout = OpenLog(filename);
	if (!level) {
		level = Logger.INFO;
	}
	this.level = level;
	
	this.log = function(level, msg) {
		if (level.idx >= this.level.idx) {
			cal = this.log.caller.caller;
			this.logout.write('[' + level.name+ '] ' +  msg + (cal ? ' <' + cal.name + '()>' : '<top>'));
		}
	}
	
	this.debug = function(msg) {
		this.log(Logger.DEBUG, msg);
	}
	
	this.info = function(msg) {
		this.log(Logger.INFO, msg);
	}
	

	this.warn = function(msg, e) {
		this.log(Logger.WARN, msg + (e ? ': ' + e : ''));
	}	

	this.error = function(msg, e) {
		this.log(Logger.ERROR, msg + (e ? ': ' + e : ''));
	}	
	
	
}

Logger.DEBUG = { idx: 1, name : 'DEBUG' };
Logger.INFO  = { idx: 2, name : 'INFO' };
Logger.WARN  = { idx: 3, name : 'WARN' };
Logger.ERROR = { idx: 4, name : 'ERROR' };
